<?php

namespace \App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Influencer extends Model 
{

    protected $table = 'influencers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function posts()
    {
        return $this->hasMany('\App\Model\Post');
    }

    public function social_media()
    {
        return $this->hasMany('\App\Model\SocialMedia');
    }

    public function interests()
    {
        return $this->hasMany('\App\Model\Category');
    }

}